
# take blocks of code from a C file and format them into an HTML doc
# Jim Henry 2000/10

&main;


sub main
{
    my $line;
    my $section_heading;
    my $printing = 0;
    while (defined ( $line = <>) ) 
    {
	if ($line =~ m{^ *\/\/\/BEGIN(.*)} ) {
	    $section_heading = $1;
	    $printing = 1;
	    print "<h2>" . $section_heading . "<\/h2> \n\n<pre>\n";
        }
	elsif ($line =~ m{^ *///END} ) {
	    $printing = 0;
	    print "\n\<\/pre>\n<hr>\n";
        }
	elsif ($printing) {
	    $formatted = &fix_sgml_metas( $line );
	    print $formatted;
	}
    }

}


sub fix_sgml_metas
{
    my $to_format = shift;

    $to_format =~ s/&/&amp;/;
    $to_format =~ s/>/&gt;/;
    $to_format =~ s/</&lt;/;

    return $to_format;
}
