
# Convert gjax-zym-byn one-character-per-letter ASCII encoding
# into standard ASCII with x or q digraphs

# (c) 2006 Jim Henry.  Creative Commons licensing (not that it will
# be useful to anybody else as-is, but feel free to copy and modify)



BEGIN {
  litero["ax"] =  "A";
  litero["cq"] =  "2"; 
  litero["cx"] =  "C";  
  litero["dx"] =  "D";
  litero["eq"] =  "E"; 

  litero["fx"] =  "F";
  litero["gx"] =  "G";
  litero["hq"] =  "#";
  litero["hx"] =  "H";

  litero["iq"] =  "I";
  litero["ix"] =  "Y";
 
  litero["jq"] =  "%";
  litero["jx"] =  "J";
  litero["kq"] =  "\\^";
  litero["kx"] =  "K";
  litero["lq"] =  "L";

  litero["mq"] =  "M";

  litero["nq"] =  "~";
  litero["nx"] =  "N";

  litero["ox"] =  "6"; 
  litero["oq"] =  "O";

  litero["px"] =  "P";
  litero["pq"] =  "*";

  litero["rq"] =  "R";

  litero["sq"] =  "\\$";
  litero["sx"] =  "S";

  litero["tq"] =  "+";
  litero["tx"] =  "T";

  litero["vx"] = "V";

  litero["zq"] = "7";
  litero["zx"] = "Z";
}

{

  for ( xlit in litero ) {
    gsub ( litero[ xlit ], xlit );
  }

  print;
}
