
# Convert gjax-zym-byn standard ASCII-transcription text with x or q
# digraphs into one-character-per-letter encoding

# (c) 2006 Jim Henry.  Creative Commons licensing (not that it will
# be useful to anybody else as-is, but feel free to copy and modify)



BEGIN {
  litero["ax"] =  "A";
  litero["cq"] =  "2"; 
  litero["cx"] =  "C";  
  litero["dx"] =  "D";
  litero["eq"] =  "E"; 

  litero["fx"] =  "F";
  litero["gx"] =  "G";
  litero["hq"] =  "#";
  litero["hx"] =  "H";

  litero["iq"] =  "I";
  litero["ix"] =  "Y";
 
  litero["jq"] =  "%";
  litero["jx"] =  "J";
  litero["kq"] =  "^";
  litero["kx"] =  "K";
  litero["lq"] =  "L";

  litero["mq"] =  "M";

  litero["nq"] =  "~";
  litero["nx"] =  "N";

  litero["ox"] =  "6"; 
  litero["oq"] =  "O";

  litero["px"] =  "P";
  litero["pq"] =  "*";

  litero["rq"] =  "R";

  litero["sq"] =  "$";
  litero["sx"] =  "S";

  litero["tq"] =  "+";
  litero["tx"] =  "T";

  litero["vx"] = "V";

  litero["zq"] = "7";
  litero["zx"] = "Z";
}

{
  # mask English words so they are not affected
  gsub ( /que/, "_QU_e" );
  gsub ( /qua/, "_QU_a" );
  gsub ( /qui/, "_QU_i" );
  gsub ( /quo/, "_QU_o" );
  gsub ( /ffix/, "__FFX__" );   # suffix,. ....
  gsub ( /ixe/, "__I_X__e" );
  gsub ( /ixi/, "__I_X__i" );
  gsub ( /mix/, "m__I_X__" );
  gsub ( /axi/, "__A_X__i" );   # axis, axial, ...
  gsub ( /syntax/, "synt__A_X__" );
  gsub ( /txt/, "_T_X_T_" );    # ASCII file extension
  gsub ( /pobox/, "pob__O_X__" );   # pobox.com, my PURL provider
  gsub ( /oxe/, "__O_X__e" );   #oxen,...
  gsub ( /oxi/, "__O_X__i" );   #oxidize....
  gsub ( /oxy/, "__O_X__y" );   #oxygen...
  gsub ( /uxi/, "__U_X__i" );   #auxiliary
  gsub ( /uxu/, "__U_X__u" );   # luxury
  gsub ( /anxi/, "a__N_X__i" );   # anxiety, anxious, ...

  for ( xlit in litero ) {
    gsub ( xlit, litero[ xlit ] );
  }

  gsub ( /_QU_/, "qu" );
  gsub ( /__FFX__/, "ffix" );
  gsub ( /__I_X__/, "ix" );
  gsub ( /__A_X__/, "ax" );
  gsub ( /__O_X__/, "ox" );
  gsub ( /__U_X__/, "ux" );
  gsub ( /_T_X_T_/, "txt" );
  gsub ( /__N_X__/, "nx" );
  print;
}
