
#cx   &#230;  
#gx   &#248;  
#hx   &#182;  
#jx   &#188;  
#sx   &#254;  


BEGIN {
  litero["ax"] =  "\\&\#226;";
  litero["cq"] =  "\\&\#269;"; 
  litero["cx"] =  "\\&\#265;";  
  litero["dx"] =  "\\&\#273;"; 
  litero["eq"] =  "\\&\#283;"; 

  litero["fx"] =  "\\&\#8355;";  # capital F with extra crossbar; franc symbol
  litero["gx"] =  "\\&\#285;";
  litero["hq"] =  "\\&\#295;"; # planck's constant sign
  litero["hx"] =  "\\&\#293;";

  litero["iq"] =  "\\&\#301;"; # i-breve.  There is no i-caron available.
  litero["ix"] =  "\\&\#238;";
 
  litero["jq"] =  "\\&\#308;";      # capital J^ - not good
  litero["jx"] =  "\\&\#309;";
  litero["kq"] =  "\\&\#1036;";  # cyrillic
  litero["kx"] =  "\\&\#311;";   # k-cedilla
  litero["lq"] =  "\\&\#321;";   # 'LATIN CAPITAL LETTER L WITH STROKE' 

  litero["mq"] =  "\\&\#625;";   # m with hook (is to m as eng is to n)
  # IPA letter for voiced labiodental nasal

  litero["nq"] =  "\\&\#328;";
  litero["nx"] =  "\\&\#331;";

  litero["ox"] =  "\\&\#244;"; 
  litero["oq"] =  "\\&\#466;"; 

  litero["px"] =  "\\&\#934;";   # capital Phi
#  litero["pq"] =  "\\&\#664;";   # IPA bilabial click
  litero["pq"] =  "\\&\#421;";   # lowercase p-hook

  litero["rq"] =  "\\&\#345;"; 

  litero["sq"] =  "\\&\#353;"; 
  litero["sx"] =  "\\&\#349;"; 

  litero["tq"] =  "\\&\#357;";  # t-apostrophe
#  litero["tx"] =  "\\&\#8364;"; # euro sign
  litero["tx"] =  "\\&\#359;"; # lowercase t with extra cross bar

  litero["ux"] = "\\&#365;";   # u-breve, not used in gzb but some Esperanto text is included in gzb files

#  litero["vx"] = "\\&\#1509;";  # something from hebrew
  litero["vx"] = "\\&\#436;";  # lowercase y-hook

  litero["zq"] = "\\&\#382;"; 
  litero["zx"] = "\\&\#378;";
}

{
  # mask English words so they are not affected
  gsub ( /que/, "_QU_e" );
  gsub ( /qua/, "_QU_a" );
  gsub ( /qui/, "_QU_i" );
  gsub ( /quo/, "_QU_o" );
  gsub ( /ffix/, "__FFX__" );
  gsub ( /ixe/, "__I_X__e" );
  gsub ( /ixi/, "__I_X__i" );
  gsub ( /mix/, "m__I_X__" );
  gsub ( /axi/, "__A_X__i" );
  gsub ( /txt/, "_T_X_T_" );
  gsub ( /oxe/, "__O_X__e" );   #oxen,...
  gsub ( /oxi/, "__O_X__i" );   #oxidize....
  gsub ( /oxy/, "__O_X__y" );   #oxygen...
  gsub ( /uxi/, "__U_X__i" );   #auxiliary
  gsub ( /uxu/, "__U_X__u" );   # luxury


  for ( xlit in litero ) {
    gsub ( xlit, litero[ xlit ] );
  }

  gsub ( /_QU_/, "qu" );
  gsub ( /__FFX__/, "ffix" );
  gsub ( /__I_X__/, "ix" );
  gsub ( /__A_X__/, "ax" );
  gsub ( /__O_X__/, "ox" );
  gsub ( /__U_X__/, "ox" );
  gsub ( /_T_X_T_/, "txt" );

  print;
}

