
BEGIN {
  print "<html>";
  print "<head>";
  print "<meta name=\"generator\" content=\"htmlize.awk\">";
  print "<body>";

  # pseudo-enum
  p = 1;
  pre = 2;
  ol = 3;
}

/^ *$/ {
  if ( in_para ) {
    if ( tag == p ) {
      print "</p>";
    } else if ( tag == pre ) {
      print "</pre>";
    } else if ( tag == ol ) {
      print "</ol>";
    }
  }
  in_para = 0;
}

! /^ *$/ {
  if ( 0 == in_para ) {
    in_para = 1;
    # three or more consecutive spaces hint we need a PRE tag
    if ( $0 ~ /    */ ) { 
      print "<pre>";
      tag = pre;
    } else if ( $0 ~ /^1\./ ) {
      print "<ol>";
      tag = ol;
    } else {
      print "<p>";
      tag = p;
    }
  }
  gsub ( "\"", "\\&quot;" );
  gsub ( "<", "\\&lt;" );
  gsub ( ">", "\\&gt;" );

  # this wants more sophistication to work across multiple lines
#  if ( sub ( "_", "<cite>" ) ) {
#     sub ( "_", "</cite>" )
#  }
}

tag != ol {
  print;
}

tag == ol {
  print "<li>" $0;
}

END {
  print "</body></html>"
}

