
# Needs more work to handle ! and ? as sentence terminators.  
# Also should not break sentence at abbreviations like Mr., Mrs., Dr. ...

function wordcount( s, a ) {
  return split( s, a, /[- ,:;]+/ );
}

BEGIN {
  current_sentence = "";
  min_words = 100;
  long_sentence_count = 0;
}

# on each nonblank line
! /^ *$/ {

  while ( (period_pos = index( $0, "." )) > 0 ) {
    current_sentence = current_sentence " " substr( $0, 1, period_pos );
    if ( (n = wordcount( current_sentence )) > min_words ) {
      print n ": " current_sentence "\n\n";
    }
    current_sentence = "";
    $0 = substr( $0, period_pos+1 );
  }
  current_sentence = current_sentence " " $0;
}

# on each blank line
/^ *$/ {
  if ( (n = wordcount( current_sentence )) > min_words ) {
    print n ": " current_sentence "\n\n";
  }
  current_sentence = "";
}
