#/usr/bin/perl

# first version assumes tab delimited input files and first field is
# numeric field to be percented.  later make these command line
# options

###TODO: command line option to look for a "total" line in the input and use
#    that number instead of the sum of all numbers in numeric column.

use strict;

my @lines;
my $total;
my $i = 0;

# read whole file before processing
while ( <ARGV> ) {
    $lines[$i] = [ split "\t" ];
    $total += $lines[$i][0];
    $i++;
}

for ( $i = 0; $i < scalar(@lines); $i++ ) {
    my $percent = sprintf( "%2.4f%%", 100 * $lines[$i][0] / $total );
    unshift @{$lines[$i]}, $percent;
    print join( "\t", @{ $lines[$i] } );
}

print $total . "\t[TOTAL]\n";
