#! /usr/bin/perl -w

use warnings;
use strict;

my $debug = 0;
my $map_file = shift;
my $direction = 0;

if  ( ! $map_file ) {
    die ( "Argument: input file with replacement map\n" );
}

my $rev;
if ( $rev = shift ) {
    if ( $rev eq "-r" ) {
	$direction = 1;
    }
}

open (MAP, $map_file) || die ("Couldn't find map file: $map_file\n");

my %map = ();
my $input_line;
while (defined ( $input_line = <MAP>) ) {
    # remove comments
    $input_line =~ s/#.*^//;
    
    # strip trailing whitespace except tabs
    $input_line =~ s/[ \n\r]+$//;
    next if  $input_line =~ m/^$/;
   
    my @in_fields = split /\t/, $input_line;
    $map{ $in_fields[0] } = $in_fields[1];
    print "map line: $in_fields[0] :: $in_fields[1]\n"   if $debug;
}

while (defined ( $input_line = <STDIN> ) ) {
#    chomp $input_line;
#    $input_line =~ s/\r//g;
    my $k;
    my $replace_code;
    foreach $k (keys %map) {
	if ( $direction == 0 ) {
	    $replace_code = "\$input_line =~ s/$k/$map{$k}/g;";
#	    print "replacement code: $replace_code \n";
	    eval $replace_code;

	    # for whatever reason, \1 \2 etc don't work in replacement text this way.
#	    $input_line =~ s/$k/$map{$k}/g;
	} else {
	    $input_line =~ s/$map{$k}/$k/g;
	}
    }
    print $input_line;
}
