# Tag words (conlang 13c) for their part of speech and length, weighted
# sum of phonemes on approximate time to pronounce

use strict;

my $fricative_weight = 0.25;
my $nasal_weight = 0.5;
my $liquid_weight = 0.375;
my $plosive_weight = 0.1;
my $vowel_weight = 1;

$, = "\t";                  # output field separator

while ( <> ) {
    s/\s+$//;
    my $fricatives = tr/xGSZszfv/xGSZszfv/;
    my $nasals = tr/mnN/mnN/;
    my $liquids = tr/lrjw/lrjw/;
    my $plosives = tr/ktpbdg/ktpbdg/;
    my $vowels = tr/aeiouA/aeiouA/;
    my $weighted_length = $vowels * $vowel_weight + $fricatives * $fricative_weight  
	+ $nasals * $nasal_weight + $liquids * $liquid_weight  + $plosives * $plosive_weight;

    my $pattern = $_;
    $pattern =~ s/[xGSZszfvktpgdbmnNlrjw]/C/g;
    $pattern =~ s/[AEIOUaeiou]/V/g;
    
    my $category;
    if ( m/[aeiouA]$/ ) {
	$category = "gp";        # grammatical particle
    } elsif ( m/[ktp]$/ ) {
	$category = "qu";        # quality or state
    } elsif ( m/[bdg]$/ ) {
	$category = "pr";        # process
    } elsif ( m/[Nnm]$/ ) {
	$category = "su";        # substance
    } elsif ( m/[lrwj]$/ ) {
	$category = "re";        # relationship
    } else {
	print STDERR "no category for $_\n";
    }

    print $_, $pattern, $weighted_length, $category, "\n";
}
