# (c) 2006 by Jim Henry III.  Creative Commons license.
# http://www.pobox.com/~jimhenry/conlang/redundancy.htm
# Generate redundant morphemes given a sequence of phoneme sets.
# Resultant morpheme set will have no two morphemes which differ by
# fewer than two phonemes.

# first version will be specialized for sequence of three phonemes
# later generalize it for four or more


my $debug = 0;
my $inputfile = shift;

if  ( ! $inputfile ) {
    die ( "Argument: input file with phoneme lists\n" );
}

open (PHONEMES, $inputfile) || die ("Couldn't find $inputfile\n");

my @phoneme_sets;
my $phoneme_set_idx = 0;
my $phoneme_idx = 0;
my $input_line;
my $phoneme_set_count = -1;
while (defined ( $input_line = <PHONEMES>) ) {
    
   chop ($input_line);
   $input_line =~ s/\r//g;
   $input_line =~ s/#.*//;  # remove comments

   if ( $input_line =~ /SLOT *([0-9]+)/ ) {
       $phoneme_set_count++;
       $phoneme_set_idx = 0;
       next;
   }
   if ($input_line !~ /^ *$/) {
       print "assigning $input_line to row $phoneme_set_count column $phoneme_set_idx\n" if $debug;
       $phoneme_sets[ $phoneme_set_count ][ $phoneme_set_idx ] = $input_line;
       $phoneme_set_idx++;
   }
}

if ( $phoneme_set_count != 2 ) {
    die ( "this version only supports 3-phoneme sequences" );
}


# now generate real morphemes.
# note this only works if we have 3 dimensions; needs extensive work to do 4 or 5

my $i = 0, $j = 0, $k = 0;
my @dimension_size;
for ( $i = 0; $i < scalar(@phoneme_sets); $i++ ) {
    my $slotref = $phoneme_sets[ $i ];
    $dimension_size[ $i ] = scalar( @{$slotref} );
    print "\$dimension_size\[ $i \]  = " .  $dimension_size[ $i ] . "\n" if $debug;
}

$i = 0, $j = 0, $k = 0, $iter = 0;
my @morpheme_prism;
my $finished = 0;

&clear_whole_prism;

while ( $finished == 0 ) {
    ++$iter;
    print "iteration $iter -- values ( $i, $j, $k ) \n" if $debug;
    &print_whole_prism  if $debug >= 2;
    print "==============\n"  if $debug >= 2;
    print "try ($i, $j, $k) \n"  if $debug;
    if ( $morpheme_prism[ $i ][ $j ][ $k ] != 1 && $morpheme_prism[ $i ][ $j ][ $k ] != 2 ) {
	&mark_used( \@morpheme_prism, $i, $j, $k );
	$i = ($i + 1) % $dimension_size[ 0 ];
	$j = ($j + 1) % $dimension_size[ 1 ];
	next;
    } elsif ( $debug ) {
	print "skipping cell [ $i, $j, $k ] as it's already used or blocked\n"
    }
    # not sure about these lines
    $i = ($i + 1) % $dimension_size[ 0 ];    
#    $j = ($j + 1) % $dimension_size[ 1 ];
    $k++;
    # double check this for off-by-one err...
    if ( $k >= $dimension_size[ 2 ] ) {
	$finished = 1;
	break;
    }
}

&print_whole_prism  if $debug;

sub print_whole_prism {

    my $m, $n, $o;
    for ( $o = 0; $o < $dimension_size [ 2 ]; $o++ ) {
	for ( $n = 0; $n < $dimension_size [ 1 ]; $n++ ) {
	    for ( $m = 0; $m < $dimension_size [ 0 ]; $m++ ) {
		if ( $morpheme_prism[ $m ][ $n ][ $o ] == 1 ) {
		    print "xxx ";
		} elsif ( $morpheme_prism[ $m ][ $n ][ $o ] == 2 ) {
###		    print $phoneme_sets[ 0 ][ $m ] . $phoneme_sets[ 1 ][ $n ] . $phoneme_sets[ 2 ][ $o ] . " ";
		    print "=== ";
		} else {
   		    print "000 ";
		}
	    }
	    print "\n";
	}
	print "\n";
    }
}


sub clear_whole_prism {
    my $m, $n, $o, $is_1;
    for ( $o = 0; $o < $dimension_size [ 2 ]; $o++ ) {
	for ( $n = 0; $n < $dimension_size [ 1 ]; $n++ ) {
	    for ( $m = 0; $m < $dimension_size [ 0 ]; $m++ ) {
		$morpheme_prism[ $m ][ $n ][ $o ] = 0;
	    }
	}
    }
}


sub mark_used {
    my ( $arr_ref, $p, $q, $r ) = @_;
    my @arr = @{ $arr_ref };
    my $z;
    
    my $previous = $arr[ $p ][ $q ][ $r ];
#    print "previous value: [" . $arr[ $p ][ $q ][ $r ] . "] " if $debug; 
    print "previous value: [ $previous ] " if $debug; 
    if ( $previous == 1 || $previous == 2 ) {
	print "bailing out of mark_used() as previous value of this cell was $previous\n";
	return;
    }
    print "marking these cells as blocked: " if $debug;
    for ( $z=0; $z< $dimension_size[ 0 ]; $z++ ) {
	$arr[ $z ][ $q ][ $r ] = 1;
	print "($z, $q, $r) " if $debug;
    }
    print "\n" if $debug;
    for ( $z=0; $z< $dimension_size[ 1 ]; $z++ ) {
	$arr[ $p ][ $z ][ $r ] = 1;
	print "($p, $z, $r) " if $debug;
    }
    print "\n" if $debug;
    for ( $z=0; $z< $dimension_size[ 2 ]; $z++ ) {
	$arr[ $p ][ $q ][ $z ] = 1;
	print "($p, $q, $z) " if $debug;
    }
    print "\n" if $debug;

    $arr[ $p ][ $q ][ $r ] = 2;
    print "marking cell [ $p, $q, $r ] as used ***** " if $debug;

    print $phoneme_sets[ 0 ][ $p ] . $phoneme_sets[ 1 ][ $q ] . $phoneme_sets[ 2 ][ $r ] . "\n";
#    print "1:" . $phoneme_sets[ 0 ][ $p ] . "2:" . $phoneme_sets[ 1 ][ $q ] .  "3:" . $phoneme_sets[ 2 ][ $r ] . "\n" . "$p $q $r\n";
    
}
