#! /usr/bin/perl

=head1 NAME

reverse-rss-to-html.pl


=head1 DESCRIPTION

Read an RSS feed XML file, and output an HTML file that has the entries in
reverse order (i.e. chronological rather than reverse chronological) with title,
pubDate, enclosure URL, and description.  Helpful when a podcast's episode mp3s
have no metadata.


=head2 SYNOPSIS

  reverse-rss-to-html.pl rss.xml


=head2 DEPENDENCIES

Requires Perl 5.14.

C<Data::Dumper> is in the standard library.

C<XML::RSS::LibXML> is in CPAN. 


=head1 AUTHOR 

Jim Henry III, L<http://jimhenry.conlang.org/software/>


=head1 LICENSE

This script is free software; you may redistribute it and/or modify it under
the same terms as Perl itself.


=head2 TO DO LIST

It should also allow you to give it an RSS URL on the command line instead of
needing to download the RSS feed with C<wget> or C<curl>.

=cut

use XML::RSS::LibXML;
use Data::Dumper;
use strict;
use v5.14;
use utf8;
use open qw(:std :utf8);

$/ = undef;

my $rssfile = <>;

my $parser = XML::RSS::LibXML->new;

$parser->parse($rssfile);

print <<HEADER;
<html>
<head>
<title>Reverse of RSS feed $ARGV[0]</title>
<body>
HEADER

foreach my $item ( reverse @{ $parser->{items} }) {
    say "<h1>$item->{title}</h1>";
    say "<p>$item->{pubDate}";
    say qq(<br><a href="$item->{enclosure}{url}">$item->{enclosure}{url}</a>);
    say "<p>$item->{description}";
    say "<hr>";
}

say "</body></html>";




